/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.config;

import com.minecraftabnormals.abnormals_core.core.annotations.ConfigKey;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class ACConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    private static String makeTranslation(String name) {
        return "abnormals_core.config." + name;
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class ValuesHolder {
        private static boolean poisonPotatoCompatEnabled;
        private static boolean poisonEffect;
        private static double poisonChance;
        private static boolean smoothSkyColorEnabled;

        public static void updateCommonValuesFromConfig(ModConfig config) {
            poisonPotatoCompatEnabled = (Boolean)ACConfig.COMMON.poisonPotatoCompatEnabled.get();
            poisonEffect = (Boolean)ACConfig.COMMON.poisonEffect.get();
            poisonChance = (Double)ACConfig.COMMON.poisonChance.get();
        }

        public static void updateClientValuesFromConfig(ModConfig config) {
            smoothSkyColorEnabled = (Boolean)ACConfig.CLIENT.enableSmoothSkyColor.get();
        }

        public static boolean isPoisonPotatoCompatEnabled() {
            return poisonPotatoCompatEnabled;
        }

        public static boolean shouldPoisonEntity() {
            return poisonEffect;
        }

        public static double poisonEffectChance() {
            return poisonChance;
        }

        public static boolean isSmoothSkyColorEnabled() {
            return smoothSkyColorEnabled;
        }
    }

    public static final class SlabfishSettings {
        @ConfigKey(value="slabfish_hat_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> enabled;
        @ConfigKey(value="slabfish_hat_backpack_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> backpackEnabled;
        @ConfigKey(value="slabfish_hat_sweater_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> sweaterEnabled;
        @ConfigKey(value="slabfish_hat_custom_type_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> typeEnabled;

        SlabfishSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Slabfish patron hat settings.").push("slabfishSettings");
            this.enabled = builder.comment("If the slabfish hat should be enabled; Default: True").translation(ACConfig.makeTranslation("slabfishHat")).define("enabled", true);
            this.backpackEnabled = builder.comment("If the slabfish hat's backpack should be enabled; Default: True").translation(ACConfig.makeTranslation("slabfishHat.backpack")).define("backpackEnabled", true);
            this.sweaterEnabled = builder.comment("If the slabfish hat's sweater should be enabled; Default: True").translation(ACConfig.makeTranslation("slabfishHat.sweater")).define("sweaterEnabled", true);
            this.typeEnabled = builder.comment("If the slabfish hat's custom type should be enabled. If false, the default swamp slabfish appears; Default: True").translation(ACConfig.makeTranslation("slabfishHat.type")).define("typeEnabled", true);
            builder.pop();
        }
    }

    public static final class Client {
        @ConfigKey(value="smooth_sky_color_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSmoothSkyColor;
        public final SlabfishSettings slabfishSettings;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings for Abnormals Core.").push("client");
            this.enableSmoothSkyColor = builder.comment("If sky color transition should be smooth; Default: True").translation(ACConfig.makeTranslation("smooth_sky_color")).define("smoothSkyColor", true);
            this.slabfishSettings = new SlabfishSettings(builder);
            builder.pop();
        }
    }

    public static class Common {
        @ConfigKey(value="quark_poison_potato_compat_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> poisonPotatoCompatEnabled;
        @ConfigKey(value="potato_poison_effect")
        public final ForgeConfigSpec.ConfigValue<Boolean> poisonEffect;
        @ConfigKey(value="potato_poison_chance")
        public final ForgeConfigSpec.ConfigValue<Double> poisonChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common only settings for Abnormals Core, this will affect all depending mods").push("common");
            builder.comment("Compatibility with Quark's poisonous potatoes feature").push("poisonousPotatoCompat");
            this.poisonPotatoCompatEnabled = builder.comment("If baby mobs can be fed a poisonous potato to stunt their growth when Quark is installed; Default: True").translation(ACConfig.makeTranslation("poison_potato_compat_enabled")).define("poisonPotatoCompatEnabled", true);
            this.poisonEffect = builder.comment("If growth stunting should give baby mobs poison; Default: True").translation(ACConfig.makeTranslation("poison_effect")).define("poisonEffect", true);
            this.poisonChance = builder.comment("The chance to stunt baby mob growth when feeding a poisonous potato; Default: 0.1").translation(ACConfig.makeTranslation("poison_chance")).defineInRange("poisonChance", 0.1, 0.0, 1.0);
            builder.pop();
            builder.pop();
        }
    }
}

